package com.jhscale.meter.protocol.print.dither;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.protocol.print.em.DotImage;

import java.awt.*;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;

/**
 * @author lie_w
 * @title: DitherVal
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-2514:21
 */
public class DitherVal implements JSONModel {

    private int x;

    private int y;

    private int width;

    private int height;

    private int[] data;

    public DitherVal() {
    }

    @Deprecated
    public DitherVal(Raster raster) {
        Rectangle bounds = raster.getBounds();
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
        DataBuffer buffer = raster.getDataBuffer();
        this.data = new int[buffer.getSize()];
        for (int i = 0; i < buffer.getSize(); i++) {
            this.data[i] = buffer.getElem(i) == 0x00 ? 1 : 0;
        }
    }

    @Deprecated
    public DitherVal(ImageBuffer buffer) {
        this(buffer, null);
    }

    @Deprecated
    public DitherVal(ImageBuffer buffer, DitherParam ditherParam) {
        this.x = buffer.getMinX();
        this.y = buffer.getMinY();
        this.width = buffer.getWidth();
        this.height = buffer.getHeight();
        if (ditherParam == null) ditherParam = new DitherParam();

        if (DotImage.Dither.equals(ditherParam.getDotImage())) {
            // 抖图处理
        } else {
            int divide = (int) (16777215 * ditherParam.getRatio());
            this.data = new int[height * width];
            int index = 0;
            // RGB色素处理
            for (int i = 0; i < buffer.getRGBHexs().length; i++) {
                for (int j = 0; j < buffer.getRGBHexs()[i].length; j++) {
                    int RGBHEX = Integer.parseInt(buffer.getRGBHexs()[i][j], 16);
                    int val = RGBHEX < divide ? 1 : 0;
                    this.data[index] = val;
                    index++;
                }
            }
        }
    }

    public int getX() {
        return x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int[] getData() {
        return data;
    }

    public void setData(int[] data) {
        this.data = data;
    }
}
