package com.jhscale.meter.protocol.print.dither;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.meter.protocol.print.image.RGB;

import java.io.Serializable;

/**
 * @author lie_w
 * @title: ImageBuffer
 * @projectName jhscale-agreement
 * @description: 图片缓冲
 * @date 2021/3/268:54
 */
public class ImageBuffer implements Serializable {

    // 最小X坐标
    private int minX;
    // 最小Y坐标
    private int minY;
    // 宽
    private int width;
    // 高
    private int height;
    // 颜色空间中的整数像素
    private String[][] RGBHexs;
    private RGB[][] rgbs;
    // 文件长度
    private long imageSize;
    // 文件全路径
    private String absolutePath;
    // 文件名
    private String name;
    // 文件后缀
    private String suffix;
    // 文件类型
    private int type;

    public ImageBuffer() {
    }

    public ImageBuffer(int width, int height, String[][] RGBHexs) {
        this.width = width;
        this.height = height;
        this.RGBHexs = RGBHexs;
    }

    public ImageBuffer(int width, int height, RGB[][] rgbs) {
        this.width = width;
        this.height = height;
        this.rgbs = rgbs;
    }

    public int getMinX() {
        return minX;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMinY() {
        return minY;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String[][] getRGBHexs() {
        return RGBHexs;
    }

    public void setRGBHexs(String[][] RGBHexs) {
        this.RGBHexs = RGBHexs;
    }

    public RGB[][] getRgbs() {
        return rgbs;
    }

    public void setRgbs(RGB[][] rgbs) {
        this.rgbs = rgbs;
    }

    public long getImageSize() {
        return imageSize;
    }

    public void setImageSize(long imageSize) {
        this.imageSize = imageSize;
    }

    public String getAbsolutePath() {
        return absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    /**
     * @description: 获取文件名
     **/
    public String getFileName() {
        return this.name + "." + this.suffix;
    }

    /**
     * @description: 对象复制
     **/
    public ImageBuffer copy() {
        return JSONObject.parseObject(JSONObject.toJSONString(this), this.getClass());
    }

}
