package com.jhscale.meter.protocol.print.dither.algorithm;


import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;

import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * @author lie_w
 * @title: Ordered2By2Bayer
 * @projectName jhscale-agreement
 * @description: TODO
 * 2 by 2 Bayer Ordered Dithering
 * 1 3
 * 4 2
 * (1/5)
 * @date 2021-01-2115:56
 */
public class Ordered2By2Bayer implements IDithering {
    /**
     * @param source
     * @description: Dither算法
     */
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), BufferedImage.TYPE_INT_RGB);

        int alpha, red;
        int pixel;
        int gray;

        int matrix[][] = {
                {1, 3},
                {4, 2},
        };

        int width = source.getWidth();
        int height = source.getHeight();
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {

                pixel = source.getRGB(x, y);

                Color withAlpha = new Color(pixel, true);
                alpha = withAlpha.getAlpha();
                red = withAlpha.getRed();

                gray = red;

                gray = gray + (gray * matrix[x % 2][y % 2]) / 5;

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }

        return out;
    }

    /**
     * @param source
     * @param imageProcess
     * @param threshold
     * @description: Dither 算法
     */
    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        int gray;
        int matrix[][] = {
                {1, 3},
                {4, 2},
        };

        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);

        for (int y = 0; y < source.getHeight(); y++) {
            for (int x = 0; x < source.getWidth(); x++) {
                RGB RGB = source.getRgbs()[y][x];

                gray = RGB.getRI();

                gray = gray + (gray * matrix[x % 2][y % 2]) / 5;

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB.getAlpha());
            }
        }
        return target;
    }
}
