package com.jhscale.meter.protocol.print.dither.algorithm;

import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;

import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * @author lie_w
 * @title: Ordered4By4Bayer
 * @projectName jhscale-agreement
 * @description: TODO
 * 4 by 4 Bayer Ordered Dithering
 * 1 9 3 11
 * 13 5 15 7
 * 4 12 2 10
 * 16 8 14 6
 * (1/17)
 * @date 2021-01-2116:01
 */
public class Ordered4By4Bayer implements IDithering {
    /**
     * @param source
     * @param threshold
     * @description: Dither算法
     */
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), BufferedImage.TYPE_INT_RGB);

        int alpha, red;
        int pixel;
        int gray;

        int matrix[][] = {
                {1, 9, 3, 11},
                {13, 5, 15, 7},
                {4, 12, 2, 10},
                {16, 8, 14, 6}};

        int width = source.getWidth();
        int height = source.getHeight();
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {

                pixel = source.getRGB(x, y);

                Color withAlpha = new Color(pixel, true);
                alpha = withAlpha.getAlpha();
                red = withAlpha.getRed();

                gray = red;

                gray = gray + (gray * matrix[x % 4][y % 4]) / 17;

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }

        return out;
    }

    /**
     * @param source
     * @param imageProcess
     * @param threshold
     * @description: Dither 算法
     */
    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        int gray;
        int matrix[][] = {
                {1, 9, 3, 11},
                {13, 5, 15, 7},
                {4, 12, 2, 10},
                {16, 8, 14, 6}};

        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);

        for (int y = 0; y < source.getHeight(); y++) {
            for (int x = 0; x < source.getWidth(); x++) {
                RGB RGB = source.getRgbs()[y][x];

                gray = RGB.getRI();

                gray = gray + (gray * matrix[x % 4][y % 4]) / 17;

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB.getAlpha());
            }
        }
        return target;
    }
}
