package com.jhscale.meter.protocol.print.dither.algorithm;

import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;

import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * @author lie_w
 * @title: Ordered8By8Bayer
 * @projectName jhscale-agreement
 * @description: TODO
 * 8 by 8 Bayer Ordered Dithering
 * 1 49 13 61 4 52 16 64
 * 33 17 45 29 36 20 48 32
 * 9 57 5 53 12 60 8 56
 * 41 25 37 21 44 28 40 24
 * 3 51 15 63 2 50 14 62
 * 35 19 47 31 34 18 46 30
 * 11 59 7 55 10 58 6 54
 * 43 27 39 23 42 26 38 22
 * (1/65)
 * @date 2021-01-2116:03
 */
public class Ordered8By8Bayer implements IDithering {

    /**
     * @param source
     * @param threshold
     * @description: Dither算法
     */
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), BufferedImage.TYPE_INT_RGB);

        int alpha, red;
        int pixel;
        int gray;

        int matrix[][] = {
                {1, 49, 13, 61, 4, 52, 16, 64},
                {33, 17, 45, 29, 36, 20, 48, 32},
                {9, 57, 5, 53, 12, 60, 8, 56},
                {41, 25, 37, 21, 44, 28, 40, 24},
                {3, 51, 15, 63, 2, 50, 14, 62},
                {35, 19, 47, 31, 34, 18, 46, 30},
                {11, 59, 7, 55, 10, 58, 6, 54},
                {43, 27, 39, 23, 42, 26, 38, 22}
        };

        int width = source.getWidth();
        int height = source.getHeight();
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {

                pixel = source.getRGB(x, y);

                Color withAlpha = new Color(pixel, true);
                alpha = withAlpha.getAlpha();
                red = withAlpha.getRed();

                gray = red;

                gray = gray + (gray * matrix[x % 8][y % 8]) / 65;

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }

        return out;
    }

    /**
     * @param source
     * @param imageProcess
     * @param threshold
     * @description: Dither 算法
     */
    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        int gray;
        int matrix[][] = {
                {1, 49, 13, 61, 4, 52, 16, 64},
                {33, 17, 45, 29, 36, 20, 48, 32},
                {9, 57, 5, 53, 12, 60, 8, 56},
                {41, 25, 37, 21, 44, 28, 40, 24},
                {3, 51, 15, 63, 2, 50, 14, 62},
                {35, 19, 47, 31, 34, 18, 46, 30},
                {11, 59, 7, 55, 10, 58, 6, 54},
                {43, 27, 39, 23, 42, 26, 38, 22}
        };

        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);

        for (int y = 0; y < source.getHeight(); y++) {
            for (int x = 0; x < source.getWidth(); x++) {
                RGB RGB = source.getRgbs()[y][x];

                gray = RGB.getRI();

                gray = gray + (gray * matrix[x % 8][y % 8]) / 65;

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB.getAlpha());
            }
        }
        return target;
    }
}
