package com.jhscale.meter.protocol.print.dither.algorithm;

import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;

import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * @author lie_w
 * @title: SierraLite
 * @projectName jhscale-agreement
 * @description: TODO
 * Sierra Lite Dithering
 * X 2
 * 1 1
 * (1/4)
 * @date 2021-01-2116:19
 */
public class SierraLite implements IDithering {
    /**
     * @param source
     * @param threshold
     * @description: Dither算法
     */
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), BufferedImage.TYPE_INT_RGB);

        int alpha, red;
        int pixel;
        int gray;

        int width = source.getWidth();
        int height = source.getHeight();
        int error = 0;
        int errors[][] = new int[width][height];

        for (int y = 0; y < height - 1; y = y + 4) {
            for (int x = 1; x < width - 1; x = x + 4) {
                pixel = source.getRGB(x, y);

                Color withAlpha = new Color(pixel, true);
                alpha = withAlpha.getAlpha();
                red = withAlpha.getRed();

                gray = red;
                if (gray + errors[x][y] < threshold) {
                    error = gray + errors[x][y];
                    gray = 0;
                } else {
                    error = gray + errors[x][y] - 255;
                    gray = 255;
                }

                errors[x + 1][y] += (2 * error) / 4;

                errors[x - 1][y + 1] += (1 * error) / 4;
                errors[x][y + 1] += (1 * error) / 4;

                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }
        return out;
    }

    /**
     * @param source
     * @param imageProcess
     * @param threshold
     * @description: Dither 算法
     */
    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        int gray, error;
        int errors[][] = new int[source.getWidth()][source.getHeight()];
        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);

        for (int y = 0; y < source.getHeight() - 1; y = y + 4) {
            for (int x = 1; x < source.getWidth() - 1; x = x + 4) {
                RGB RGB = source.getRgbs()[y][x];

                gray = RGB.getRI();
                if (gray + errors[x][y] < threshold) {
                    error = gray + errors[x][y];
                    gray = 0;
                } else {
                    error = gray + errors[x][y] - 255;
                    gray = 255;
                }

                errors[x + 1][y] += (2 * error) / 4;

                errors[x - 1][y + 1] += (1 * error) / 4;
                errors[x][y + 1] += (1 * error) / 4;

                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB.getAlpha());
            }
        }
        return target;
    }
}
