package com.jhscale.meter.protocol.print.dither.algorithm;

import com.jhscale.meter.protocol.print.dither.IDithering;
import com.jhscale.meter.protocol.print.dither.ImageBuffer;
import com.jhscale.meter.protocol.print.image.ImageProcess;
import com.jhscale.meter.protocol.print.image.RGB;

import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * @author lie_w
 * @title: SimpleThreshold
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-2116:35
 */
public class SimpleThreshold implements IDithering {
    /**
     * @param source
     * @param threshold
     * @description: Dither算法
     */
    @Override
    public BufferedImage dither(BufferedImage source, int threshold) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), BufferedImage.TYPE_INT_RGB);

        int alpha, red;
        int pixel;
        int gray;

        int width = source.getWidth();
        int height = source.getHeight();

        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {

                pixel = source.getRGB(x, y);

                Color withAlpha = new Color(pixel, true);
                alpha = withAlpha.getAlpha();
                red = withAlpha.getRed();

                gray = red;

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                Color outColor = new Color(gray, gray, gray, alpha);
                out.setRGB(x, y, outColor.getRGB());
            }
        }

        return out;
    }

    /**
     * @param source
     * @param imageProcess
     * @param threshold
     * @description: Dither 算法
     */
    @Override
    public ImageBuffer dither(ImageBuffer source, ImageProcess imageProcess, int threshold) {
        int gray;
        RGB[][] targetRGB = new RGB[source.getHeight()][source.getWidth()];
        ImageBuffer target = source.copy();
        target.setRgbs(targetRGB);

        for (int y = 0; y < source.getHeight(); y++) {
            for (int x = 0; x < source.getWidth(); x++) {
                RGB RGB = source.getRgbs()[y][x];

                gray = RGB.getRI();

                if (gray < threshold) {
                    gray = 0;
                } else {
                    gray = 255;
                }

                targetRGB[y][x] = imageProcess.writeRGB(gray, gray, gray, RGB.getAlpha());
            }
        }
        return target;
    }
}
