package com.jhscale.meter.protocol.print.em;

/**
 * @author lie_w
 * @title: Barcode
 * @projectName jhscale-agreement
 * @description: 条码类型
 * @date 2020-12-2418:12
 */
public enum Barcode {

    EAN13("0100000000000000", "01", "仅数字0-9", "12或 13", "少一位时自动添加一位校验。全长度时如最后一位不符合校验，大部分扫描枪会不识别。"),
    EAN8("0200000000000000", "02", "仅数字0-9", "7或 8", "少一位时自动添加一位校验。全长度时如最后一位不符合校验，大部分扫描枪会不识别。"),
    UPC_A("0300000000000000", "03", "仅数字0-9", "11或 12", "少一位时自动添加一位校验。全长度时如最后一位不符合校验，大部分扫描枪会不识别。"),
    UPC_E("0400000000000000", "04", "仅数字0-9", "6或 7", "少一位时自动添加一位校验。全长度时如最后一位不符合校验，大部分扫描枪会不识别。"),
    EAN128_C("0500000000000000", "05", "仅数字0-9", "无限制", "奇数时自动添加校验，偶数长度不添加。"),
    Code128_C("0600000000000000", "06", "仅数字0-9", "无限制", "奇数时自动添加校验，偶数长度不添加。"),
    ITF25("0700000000010814", "07", "仅数字0-9", "无限制", "奇数时自动添加校验，偶数长度不添加。"),
    PDF417("0809000002060000", "08", "无限制", "无限制", "本版本暂不开放"),
    EAN128_Auto("0900000000000000", "09", "无限制", "无限制", ""),
    Code128_Auto("0A00000000000000", "0A", "无限制", "无限制", ""),
    QR("0B00000000000000", "0B", "无限制", "无限制", ""),
    Code39_Std("0C00000000000000", "0C", "数字字母", "无限制", ""),
    Code39_Ext("0D00000000000000", "0D", "数字字母", "无限制", ""),
    Code93("0E00000000000000", "0E", "数字字母", "无限制", ""),;

    private String val;

    private String type;

    private String limit;

    private String length;

    private String remark;

    Barcode(String val, String type, String limit, String length, String remark) {
        this.val = val;
        this.type = type;
        this.limit = limit;
        this.length = length;
        this.remark = remark;
    }

    public String getType() {
        return type;
    }

    public String getVal() {
        return val;
    }

    public String getLimit() {
        return limit;
    }

    public String getLength() {
        return length;
    }

    public String getRemark() {
        return remark;
    }
}
