package com.jhscale.meter.protocol.print.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: CardState
 * @projectName meter-jar
 * @description: TODO
 * @date 2022/8/118:57
 */
public enum CardState {

    SUCCESS_0("00", "命令成功（吉卡云加密卡）"),
    SUCCESS_1("01", "命令成功（非加密卡）（内ID=空，外ID=”_”+32位HEX）"),
    SUCCESS_2("02", "命令成功（未知加密卡）（内ID=空，外ID=”_”+8位HEX）"),
    NO_CARD("03", "无卡"),
    PWD_ERROR("04", "密码错误"),
    DEVICE_ERROR("05", "设备错误"),
    CMD_ERROR("06", "命令错误"),
    DELAY_STATE("07", "延迟状态"),
    TIME_OUT("08", "超时错误"),
    UNKNOWN("F0", "未知错误");

    private String state;
    private String description;

    CardState(String state, String description) {
        this.state = state;
        this.description = description;
    }

    public static CardState state(String state) {
        if (StringUtils.isNotBlank(state)) {
            for (CardState cardState : CardState.values()) {
                if (state.equalsIgnoreCase(cardState.getState())) return cardState;
            }
        }
        return UNKNOWN;
    }

    /**
     * @description: 存在结果状态
     **/
    public static boolean result(String result) {
        if (StringUtils.isNotBlank(result)) {
            return result.equalsIgnoreCase(SUCCESS_0.state)
                    || result.equalsIgnoreCase(SUCCESS_1.state)
                    || result.equalsIgnoreCase(SUCCESS_2.state);
        }
        return false;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
