package com.jhscale.meter.protocol.print.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: Dither
 * @projectName jhscale-agreement
 * @description: 抖图处理类型
 * @date 2021/3/262:57
 */
public enum DotImage {
    Dither("Dither"), Color("Color");

    private String name;

    DotImage(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public DotImage getDotImage(String name) {
        if (StringUtils.isNotBlank(name)) {
            for (DotImage dotImage : DotImage.values()) {
                if (dotImage.getName().equals(name)) return dotImage;
            }
        }
        return null;
    }
}
