package com.jhscale.meter.protocol.print.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: Font
 * @projectName jhscale-agreement
 * @description: 字体类型
 * @date 2020-12-2412:45
 */
public enum Font {

    FONT(0x00, "00", "16*16"),
    FONT1(0x01, "01", "24*24"),
    FONT2(0x02, "02", "32*32"),
    FONT3(0x03, "03", "32*16"),
    FONT4(0x04, "04", "48*24"),
    FONT5(0x05, "05", "64*32"),
    FONT6(0x06, "06", "48*48"),
    FONT7(0x07, "07", "64*64"),
    FONT8(0x08, "08", "96*48"),
    FONT9(0x09, "09", "96*96");

    private Integer val;

    private String hexVal;

    private String description;

    Font(Integer val, String hexVal, String description) {
        this.val = val;
        this.hexVal = hexVal;
        this.description = description;
    }

    public Integer getVal() {
        return val;
    }

    public String getHexVal() {
        return hexVal;
    }

    public String getDescription() {
        return description;
    }

    public static Font getFont(Integer val) {
        if (Objects.nonNull(val)) {
            for (Font font : Font.values()) {
                if (font.getVal().equals(val)) return font;
            }
        }
        return null;
    }

    public static Font getFont(String hexVal) {
        if (StringUtils.isNotBlank(hexVal)) {
            for (Font font : Font.values()) {
                if (font.getHexVal().equals(hexVal)) return font;
            }
        }
        return null;
    }
}
