package com.jhscale.meter.protocol.print.em;

/**
 * @author lie_w
 * @title: ParaType
 * @projectName jhscale-agreement
 * @description: 打印指令类型
 * @date 2020-12-2413:55
 */
public enum ParaType {

    String(0x12, "12", "字符串"),
    Bar_Code(0x14, "14", "条码"),
    Real_Time_Bitmap(0x15, "15", "即时位图"),
    Temp_Bitmap(0x16, "16", "暂存位图"),
    Set_Draw_Site(0x10, "10", "设置绘制位置"),
    Frame(0x0A, "0A", "边框"),
    Print(0x04, "04", "打印"),
    Paper(0x05, "05", "走纸"),
    Cutting_Position(0x07, "07", "走纸切割位"),
    Change_Bit_Line(0x10, "10", "修改绘图标线"),
    Print_Line(0x17, "17", "指定函数打印");

    private Integer val;

    private String hexVal;

    private String description;

    ParaType(Integer val, String hexVal, String description) {
        this.val = val;
        this.hexVal = hexVal;
        this.description = description;
    }

    public Integer getVal() {
        return val;
    }

    public String getHexVal() {
        return hexVal;
    }

    public String getDescription() {
        return description;
    }


}
