package com.jhscale.meter.protocol.print.em;

import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.entity.PrintMark;

/**
 * @author lie_w
 * @title: PrintType
 * @projectName jhscale-agreement
 * @description: 打印机功能类型
 * @date 2020-12-2116:59
 */
public enum PrintType {

    CMD("000", 0),
    PRINT_DATA("001", 1),
    BIT_MAP("010", 2),
    FONT("110", 6),
    UPGRADE("111", 7);

    private String bitVal;

    private Integer cmdVal;

    PrintType(String bitVal, Integer cmdVal) {
        this.bitVal = bitVal;
        this.cmdVal = cmdVal;
    }

    public String getBitVal() {
        return bitVal;
    }

    public Integer getCmdVal() {
        return cmdVal;
    }

    @Override
    public String toString() {
        return "PrintType{" +
                "bitVal='" + bitVal + '\'' +
                ", cmdVal=" + cmdVal +
                '}';
    }

    /**
     * @description: 初始化指令
     **/
    public String init() {
        PrintMark mark = new PrintMark(false, false, false, false, this);
        return new StringBuffer(PrintConstant.PRINT_START_TOP)
                .append(mark.buildMark())
                .append("00")
                .toString();
    }
}
