package com.jhscale.meter.protocol.print.entity;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.utils.PrintUtils;

/**
 * @author lie_w
 * @title: PrintPackageMark
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-2116:37
 */
public class PrintMark implements JSONModel {

    private String mark;

    // 0- false -发送  1- true -应答
    private boolean ack;

    // 预留字段
    private String remark = "1";

    // CRC 0- false -无 1- true -有
    private boolean crc;

    // 0- false -无 1- true -起始标志
    private boolean start;

    // 0- false -无 1- true -结束标志
    private boolean end;

    // 0=命令 CMD 1=打印数据 2=位图数据 6=字库数据 7=升级数据
    private PrintType cd;

    public PrintMark() {
    }

    public PrintMark(boolean ack, boolean crc, boolean start, boolean end, PrintType type) {
        this(ack, "1", crc, start, end, type);
    }

    public PrintMark(boolean ack, boolean crc, boolean start, PrintType type) {
        this(ack, "1", crc, start, true, type);
    }

    public PrintMark(boolean ack, PrintType type) {
        this(ack, "1", false, false, false, type);
    }

    public PrintMark(PrintType type) {
        this(false, "1", false, true, true, type);
    }

    /**
     * @description: 构建
     **/
    public PrintMark(boolean ack, String remark, boolean crc, boolean start, boolean end, PrintType type) {
        this.ack = ack;
        this.remark = remark;
        this.crc = crc;
        this.start = start;
        this.end = end;
        this.cd = type;
    }

    /**
     * @description: 解析
     **/
    public PrintMark(String hex) {
        this.mark = hex;
        String bitStr = Integer.toBinaryString(Integer.parseInt(hex, 16));
        this.ack = "1".equals(String.valueOf(bitStr.charAt(0)));
        this.remark = String.valueOf(bitStr.charAt(1));
        this.crc = "1".equals(String.valueOf(bitStr.charAt(2)));
        this.start = "1".equals(String.valueOf(bitStr.charAt(3)));
        this.end = "1".equals(String.valueOf(bitStr.charAt(4)));
        int cd = Integer.parseInt(bitStr.substring(5, 8), 2);
        if (cd == PrintType.CMD.getCmdVal()) {
            this.cd = PrintType.CMD;
        } else if (cd == PrintType.PRINT_DATA.getCmdVal()) {
            this.cd = PrintType.PRINT_DATA;
        } else if (cd == PrintType.PRINT_DATA.getCmdVal()) {
            this.cd = PrintType.PRINT_DATA;
        } else if (cd == PrintType.BIT_MAP.getCmdVal()) {
            this.cd = PrintType.BIT_MAP;
        } else if (cd == PrintType.FONT.getCmdVal()) {
            this.cd = PrintType.FONT;
        } else if (cd == PrintType.UPGRADE.getCmdVal()) {
            this.cd = PrintType.UPGRADE;
        }
    }

    @Override
    public String toString() {
        return "PrintMark{" +
                "mark='" + mark + '\'' +
                ", ack=" + ack +
                ", remark='" + remark + '\'' +
                ", crc=" + crc +
                ", start=" + start +
                ", end=" + end +
                ", cd=" + cd +
                '}';
    }

    /**
     * @description: 构建MARK
     **/
    public String buildMark() {
        StringBuffer sb = new StringBuffer().append(this.ack ? "1" : "0")
                .append(this.remark)
                .append(this.crc ? "1" : "0")
                .append(this.start ? "1" : "0")
                .append(this.end ? "1" : "0")
                .append(this.cd.getBitVal());
        PrintUtils.debug(null, String.format("Mark：[%s]", sb.toString()));
        // PrintFactory.getInstance().debug(String.format("Mark：[%s]", sb.toString()));
        String mark = Integer.toString(Integer.parseInt(sb.toString(), 2), 16);
        if (mark.length() % 2 != 0) mark = "0" + mark;
        this.mark = mark;
        return this.getMark();
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public boolean isAck() {
        return ack;
    }

    public void setAck(boolean ack) {
        this.ack = ack;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isCrc() {
        return crc;
    }

    public void setCrc(boolean crc) {
        this.crc = crc;
    }

    public boolean isStart() {
        return start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public boolean isEnd() {
        return end;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public PrintType getCd() {
        return cd;
    }

    public void setCd(PrintType cd) {
        this.cd = cd;
    }
}
