package com.jhscale.meter.protocol.print.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintCommunication;
import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.entity._interface.IPrintRequest;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.utils.PrintUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: PrintRequest
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-2210:24
 */
public class PrintRequest<T extends PrintResponse> implements IPrintRequest {

    // 串口通讯器
    private PrintCommunication communication;

    // 前置对象
    private IPrintBack printBack;

    // 请求内容
    private String content = "";

    // 发送片段
    private String subContent = "";

    // 首次 默认首次
    private boolean first = true;

    // 起始位置
    private Integer start = 0;

    // 截至位置
    private Integer end = 0;

    // crc
    private String crc;

    // SDK命令
    private boolean sdk = false;

    // 发送整包
    private boolean all = false;

    // 升级关闭
    private boolean upgrade = false;

    /**
     * @description: 是否为起始位置
     **/
    public boolean isStart() {
        return this.start == 0;
    }

    /**
     * @description: 是否为截至位置
     **/
    public boolean isEnd() {
        return this.end.equals(this.content.length());
    }

    /**
     * @description: 获取发送内容
     **/
    public String subContent() {
        this.subContent = this.content.substring(start, end);
        return this.subContent;
    }

    /**
     * @description: 发送内容长度
     **/
    public Integer subContentLength() {
        return this.subContent.length();
    }

    /**
     * @description: 发送内容Hex 长度
     **/
    public String subContentHexLength() {
        String hexLength = Integer.toHexString(this.subContentLength() / 2);
        return hexLength.length() % 2 != 0 ? "0" + hexLength : hexLength;
    }

    /**
     * @description: 设置发送长度
     **/
    public PrintRequest setSubContentLength(Integer bufferLength) {
        this.start = this.end;
        this.end = this.end + bufferLength;
        if (this.end > this.content.length()) this.end = this.content.length();
        PrintUtils.debug(this.communication.param(), String.format("bufferLength：[%s]， start：[%s]，end：[%s]", bufferLength, this.start, this.end));
        return this;
    }

    /**
     * @description: 结束位置等于Content 长度
     **/
    public boolean sendEnd() {
        return this.end.equals(this.content.length());
    }

    /**
     * @description: 是否CRC
     **/
    public boolean hasCrc() {
        return StringUtils.isNotBlank(this.crc);
    }

    /**
     * @description: 获取发送内容
     **/
    public String cmd() throws MeterException {
        PrintMark mark = new PrintMark(false, this.hasCrc(), this.isStart(), this.isEnd(), this.printType());
        String content = this.subContent();
        PrintUtils.debug(this.communication.param(), String.format("Content: [ %s ]，SubContent: [ %s ]", this.getContent(), content));
        String contentHexLength = this.subContentHexLength();
        return new StringBuffer(PrintConstant.PRINT_START_TOP)
                .append(mark.buildMark())
                .append(contentHexLength)
                .append(content)
                .toString();
    }


    public IPrintBack getPrintBack() {
        return printBack;
    }

    public void setPrintBack(IPrintBack printBack) {
        this.printBack = printBack;
    }

    public PrintCommunication getCommunication() {
        return communication;
    }

    public void setCommunication(PrintCommunication communication) {
        this.communication = communication;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public boolean isFirst() {
        return first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public Integer getStart() {
        return start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getEnd() {
        return end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public String getCrc() {
        return crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public boolean isSdk() {
        return sdk;
    }

    public void setSdk(boolean sdk) {
        this.sdk = sdk;
    }

    public boolean isAll() {
        return all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public boolean isUpgrade() {
        return upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }
}
