package com.jhscale.meter.protocol.print.entity;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.GJSONUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName meter-jar
 * @title: ServerNotify
 * @description: TODO
 * @date 2024/11/13 14:03
 */
public class ServerNotify extends JSONModel {

    // 指令类型 1-日志明细打印
    private int command;

    // 指令内容
    private String content;

    public ServerNotify() {
    }

    public static ServerNotify build() {
        return new ServerNotify();
    }

    /**
     * @description: 内容转报表
     * @date: 2024-11-13 15:51:22
     **/
    public <T> T contentToObj(Class<T> clazz) {
        return GJSONUtils.jsonToObject(this.content, clazz);
    }

    public int getCommand() {
        return command;
    }

    public ServerNotify setCommand(int command) {
        this.command = command;
        return this;
    }

    public String getContent() {
        return content;
    }

    public ServerNotify setContent(String content) {
        this.content = content;
        return this;
    }
}
