package com.jhscale.meter.protocol.print.entity._interface;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.em.PrintType;

/**
 * @author lie_w
 * @title: IPrintRequest
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-239:00
 */
public interface IPrintRequest<T extends IPrintResponse> extends JSONModel {

    /**
     * @description: 打印类型
     **/
    default PrintType printType() throws MeterException {
        throw new MeterException(MeterStateEnum.无效打印类型);
    }

    /**
     * @description: 拼装
     **/
    default StringBuffer assembler() {
        return new StringBuffer("");
    }

    /**
     * @description: 超时处理
     **/
    default void timeOut() {
    }
}
