package com.jhscale.meter.protocol.print.entity._interface;

import com.jhscale.common.model.inter.JSONModel;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;

/**
 * @author lie_w
 * @title: IPrintResponse
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-239:03
 */
public interface IPrintResponse<T extends PrintBackResponse, U extends PrintRequest> extends JSONModel {

    /**
     * @description: 回调处理
     **/
    void callBack(String responseStr, U request);

    /**
     * @description: 响应结果信息
     **/
    default void responseBody(T response, U request) throws MeterException {
    }

    /**
     * @description: 检查响应字符串
     **/
    boolean checkResponse(String responseStr) throws MeterException;

    /**
     * @description: 拆包解析
     **/
    String parse(String responseStr) throws MeterException;

    /**
     * @description: 检查响应体业务
     **/
    boolean parseCheck(U request) throws MeterException;

    /**
     * @param request
     * @description: 内容解析
     */
    default void analysis(U request) {
    }

    /**
     * @description: 内容解析
     **/
    default boolean analysisCheck(PrintRequest request) throws MeterException {
        return true;
    }
}
