package com.jhscale.meter.protocol.print.entity.bitmap;

import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.utils.ByteUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Loveven
 * @title: FileBitMap
 * @projectName jhscale-agreement
 * @description: 位图文件
 * @date 2021-01-2813:51
 */
public class FileBitMap extends BitMap<FileBitMap> {

    private static final String TOP = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    private static final int BITMAP_MAX_SIZE = 4096;

    // 位图编号
    private Integer number;

    // 位图字节长度
    private Integer length;

    // 位图占用空间
    private Integer size;

    // 位图字节流信息
    private String content;

    @Override
    public FileBitMap bulid() {
        DitherVal ditherVal = super.getDitherVal();
        if (ditherVal != null && ditherVal.getData() != null && ditherVal.getData().length > 0) {
            StringBuffer buffer = new StringBuffer()
                    .append(ByteUtils.completeBytes(this.number, 4))
                    .append(ByteUtils.completeBytes(ditherVal.getWidth(), 2))
                    .append(ByteUtils.completeBytes(ditherVal.getHeight(), 2))
                    .append(TOP);

            StringBuffer result = buffer.append(copyOfRange(ditherVal, append()));
            this.length = result.length() / 2;
            this.size = this.length % BITMAP_MAX_SIZE == 0 ? this.length / BITMAP_MAX_SIZE : ((int) (this.length / BITMAP_MAX_SIZE) + 1);
            this.content = result.toString();
        }
        return this;
    }

    public FileBitMap setNumber(int number) {
        this.number = number;
        return this;
    }

    /**
     * @description: 当前序号
     **/
    public Integer getNumber() {
        return number;
    }

    /**
     * @description: 位图字节长度
     **/
    public Integer getLength() {
        return length;
    }

    /**
     * @description: 位图文件占用大小
     **/
    public Integer getSize() {
        return size;
    }

    /**
     * @description: 下一个序号
     **/
    public Integer nextNumber() {
        return (this.number != null || this.number == 0 ? this.number : 1) + (this.size != null ? this.size : 0);
    }

    /**
     * @description: 位图占用磁盘序号
     **/
    public Integer[] numbers() {
        List<Integer> integers = new ArrayList<>();
        if (this.number != null && this.size != null) {
            for (int i = this.number; i < nextNumber(); i++) {
                integers.add(i);
            }
        }
        return integers.toArray(new Integer[integers.size()]);
    }

    /**
     * @description: 获取字节流信息
     **/
    public String getContent() {
        return this.content;
    }
}
