package com.jhscale.meter.protocol.print.entity.bitmap;

import com.jhscale.meter.protocol.print.dither.DitherVal;
import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.data.PrintRealBitmapRequest;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;

import java.io.File;

/**
 * @author Loveven
 * @title: RealBitMap
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-2815:43
 */
public class RealBitMap extends BitMap<RealBitMap> {

    // 位图信息
    private String content;

    // 字节长度
    private int length;

    // 当前行数
    private int nowline = 0;

    // 上次发送行数
    private int lastLine = 0;

    @Override
    public RealBitMap rotate(Dir dir) {
        return super.rotate(dir);
    }

    @Override
    public RealBitMap rotate(Dir dir, File rotate) {
        return super.rotate(dir, rotate);
    }

    @Override
    public RealBitMap bulid() {
        DitherVal ditherVal = super.getDitherVal();
        if (ditherVal != null && ditherVal.getData() != null && ditherVal.getData().length > 0) {
            StringBuffer buffer = copyOfRange(ditherVal, append());
            this.content = buffer.toString();
            this.length = buffer.length() / 2;
        }
        return this;
    }

    public String getContent() {
        return content;
    }

    public int getLength() {
        return length;
    }

    /**
     * @description: 检查行数
     **/
    public boolean checkLine() {
        return super.getDitherVal().getHeight() == this.nowline;
    }

    /**
     * @description: 获取最大行数
     **/
    public void getSubContent(RealBitmapPara realBitmapPara, int bufferLength) {
        realBitmapPara
                .setStartX(realBitmapPara.getStart_x())
                .setStartY(realBitmapPara.getStart_y() + this.lastLine);
        // 能接受最大行数
        int line = (int) (bufferLength / super.getLineLength());
        // 发送高度
        this.lastLine = (nowline + line > super.getDitherVal().getHeight()) ? super.getDitherVal().getHeight() - nowline : line;
        // 发送内容坐标
        int start = super.getLineLength() * this.nowline * 2;
        // 设置当前发送行数
        this.nowline += this.lastLine;
        int end = super.getLineLength() * this.nowline * 2;
        // 设置发送内容高度和内容
        realBitmapPara
                .setSizeX(super.getDitherVal().getWidth())
                .setSizeY(this.lastLine)
                .setData(this.content.substring(start, end));
    }

    public ScheduleState schedule(PrintRealBitmapRequest request) {
        return new ScheduleState(request.getCommunication().getSerial(), nowline, super.getDitherVal().getHeight());
    }
}
