package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.PrintInfoResponse;

/**
 * @author lie_w
 * @title: Print0000Request
 * @projectName jhscale-agreement
 * @description: 2.1  获取打印机信息(CMD=0x0000)
 * @date 2020-12-2315:05
 */
public class Print0000Response extends PrintCmdResponse<PrintInfoResponse, PrintRequest> {

    // 识别号
    private String firmwareVersion;

    // 升级号
    private String upgradeVersion;

    // 字体号
    private String fontVersion;

    // 打印状态1
    private String printState1;

    // 打印状态2
    private String printState2;

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.firmwareVersion = parseBytes(4);
        this.upgradeVersion = parseBytes(4);
        this.fontVersion = parseBytesInt(4);
        this.printState1 = toBitval();
        this.printState2 = toBitval();
        PrintGeneralFactory.getInstance().putPrintState(this.getSerial(), this.printState1, this.printState2);
    }

    @Override
    public void responseBody(PrintInfoResponse response, PrintRequest request) {
        try {
            response.setFirmwareVersion(this.firmwareVersion);
            response.setUpgradeVersion(this.ConvertNum2Date(this.upgradeVersion));
            response.setUpgrade(this.upgradeVersion);
            response.setFontVersion(this.fontVersion);
            response.setFont(Integer.parseInt(this.fontVersion));
            response.setState1(this.printState1);
            response.setState2(this.printState2);
            response.setBusy(PrintConstant.ZERO == this.printState1.charAt(1));
            response.setCache(PrintConstant.ZERO == this.printState1.charAt(2));
            response.setPaper(PrintConstant.ZERO == this.printState2.charAt(1));
            response.setThermal(PrintConstant.ZERO == this.printState2.charAt(2));
            response.setPaperSoon(PrintConstant.ZERO == this.printState2.charAt(3));
            response.setPaperErr(PrintConstant.ZERO == this.printState2.charAt(4));
            response.setPaperTake(PrintConstant.ZERO == this.printState2.charAt(5));
            response.setUnclosed(PrintConstant.ZERO == this.printState2.charAt(6));
        } catch (Exception e) {
        }
    }

    public String getFirmwareVersion() {
        return firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public String getUpgradeVersion() {
        return upgradeVersion;
    }

    public void setUpgradeVersion(String upgradeVersion) {
        this.upgradeVersion = upgradeVersion;
    }

    public String getFontVersion() {
        return fontVersion;
    }

    public void setFontVersion(String fontVersion) {
        this.fontVersion = fontVersion;
    }

    public String getPrintState1() {
        return printState1;
    }

    public void setPrintState1(String printState1) {
        this.printState1 = printState1;
    }

    public String getPrintState2() {
        return printState2;
    }

    public void setPrintState2(String printState2) {
        this.printState2 = printState2;
    }

    private String ConvertNum2Date(String number) {
        try {
            int num = Integer.parseInt(number);
            int year = (num >> 9) & 0x7f;
            int month = (num >> 5) & 0x0f;
            int day = (num) & 0x1f;
            return String.valueOf(year * 10000 + month * 100 + day);
        } catch (Exception e) {
            e.printStackTrace();
            return number;
        }
    }
}
