package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.em.PrintParamSave;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: Print0000Request
 * @projectName jhscale-agreement
 * @description: 2.2  打印机参数设定(CMD=0x0001)
 * @date 2020-12-2315:05
 */
public class Print0100Request extends PrintCmdRequest<Print0100Response> {

    // 参数项
    private String item;

    // 永久保存
    private PrintParamSave save = PrintParamSave.FOREVER;

    private Object val;

    @Override
    public StringBuffer assembler() {
        String hexVal = null;
        if (val instanceof Integer) {
            hexVal = ByteUtils.int2Hex((Integer) val);
        } else if (val instanceof Double || val instanceof Float) {
            hexVal = ByteUtils.int2Hex(Integer.parseInt(val.toString().substring(0, val.toString().indexOf("."))));
        } else {
            hexVal = (String) val;
        }
        return super.assembler()
                .append(this.item)
                .append(this.save.getCode())
                .append(hexVal);
    }

    public Print0100Request() {
        super("0100");
    }

    public Print0100Request(int item, PrintParamSave save, int val) {
        this();
        this.setItem(item);
        this.save = save;
        this.val = val;
    }

    public String getItem() {
        return item;
    }

    public void setItem(Integer item) {
        this.item = ByteUtils.int2Hex(item);
    }

    public void setItem(String item) {
        this.item = item;
    }

    public PrintParamSave getSave() {
        return save;
    }

    public void setSave(PrintParamSave save) {
        this.save = save;
    }

    public Object getVal() {
        return val;
    }

    public void setVal(Object val) {
        this.val = val;
    }
}
