package com.jhscale.meter.protocol.print.entity.cmd;

/**
 * @author lie_w
 * @title: Print0000Request
 * @projectName jhscale-agreement
 * @description: 2.3  打印机关保护(CMD=0x0002)
 * 在执行升级或字库下载前，必须调用此命令。且在接受任何其他命令后，保护自动开启。主要防止因为串口错误，导致字库或程序丢失。
 * @date 2020-12-2315:05
 */
public class Print0200Request extends PrintCmdRequest<Print0200Response> {

    // 固定串 0x20~0x5f
    private String cmd0200 = "202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F";

    public Print0200Request() {
        super("0200");
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler()
                .append(this.cmd0200);
    }

    public String getCmd0200() {
        return cmd0200;
    }

    public void setCmd0200(String cmd0200) {
        this.cmd0200 = cmd0200;
    }
}
