package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.ShutdownProtectionResponse;

/**
 * @author lie_w
 * @title: Print0000Request
 * @projectName jhscale-agreement
 * @description: 2.3  打印机关保护(CMD=0x0002)
 * @date 2020-12-2315:05
 */
public class Print0200Response extends PrintCmdResponse<ShutdownProtectionResponse, PrintRequest> {

    // 操作结果 01=命令成功，保护失效，00=命令失败，依然保护中
    private String result;

    @Override
    public void responseBody(ShutdownProtectionResponse response, PrintRequest request) {
        response.setResult("01".equals(this.result));
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = parseLength(1);
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public boolean isResult() {
        return "01".equals(result);
    }
}
