package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.OpenCashBoxResponse;

/**
 * @author lie_w
 * @title: Print0300Response
 * @projectName jhscale-agreement
 * @description: 2.4  开钱箱(CMD=0x0003)
 * @date 2020-12-2415:35
 */
public class Print0300Response extends PrintCmdResponse<OpenCashBoxResponse, PrintRequest> {

    // 操作结果 0=命令成功，保护失效，1=命令失败，依然保护中
    private String result;

    @Override
    public void responseBody(OpenCashBoxResponse response, PrintRequest request) {
        response.setResult(checkResult(this.result));
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = parseLength(1);
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }
}
