package com.jhscale.meter.protocol.print.entity.cmd;

/**
 * @author lie_w
 * @title: Print0400Request
 * @projectName jhscale-agreement
 * @description: 2.5  获取JKY卡信息(CMD=0x0004)
 * @date 2021-01-1214:51
 */
public class Print0400Request extends PrintCmdRequest<Print0400Response> {

    // 延迟时间秒数
    private int delay;

    /**
     * @description: 默认构造函数 0=不延迟，读取当前卡状态；
     **/
    public Print0400Request() {
        super("0400");
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler()
                .append(super.int2Byte(this.delay));
    }

    /**
     * @description: MS
     * 0 0=不延迟，读取当前卡状态；
     * 0x0001~0xfffe（小端）=延迟该数值秒，在该时效内单次自动读卡并回复，如超时，回复超时错误；
     * Null 就是永久 0xffff=永久性自动读卡并回复，若要取消本状态，发送延迟=0x0000来覆盖本状态
     **/
    public Print0400Request specify(int... delay) {
        if (delay != null && delay.length == 1) {
            this.delay = delay[0];
        } else {
            this.delay = 65535;
        }
        return this;
    }

    public int getDelay() {
        return delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }
}
