package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: Print0500Request
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-1216:14
 */
public class Print0500Request extends PrintCmdRequest<Print0500Response> {

    // 内ID
    private String innerId;

    // 外ID
    private String outerId;

    public Print0500Request() {
        super("0500");
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler()
                .append(assemblerText(this.innerId))
                .append(assemblerText(this.outerId));
    }

    public String getInnerId() {
        return innerId;
    }

    public void setInnerId(String innerId) {
        this.innerId = innerId;
    }

    public String getOuterId() {
        return outerId;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    /**
     * @description: 原本提供字节转换成Base64 如果已经Base64了不需要执行此操作
     **/
    public void innerHex(RSAEncryptDecrypt rsaEncryptDecrypt) {
        if (rsaEncryptDecrypt != null && this.innerId != null)
            this.innerId = new String(rsaEncryptDecrypt.encrypt(ByteUtils.fromHexString(this.innerId.trim())));
    }
}
