package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.em.CardState;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.MakeJKYCardResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: Print0500Response
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-1216:14
 */
public class Print0500Response extends PrintCmdResponse<MakeJKYCardResponse, PrintRequest> {

    // 结果
    // 0=命令成功（吉卡云加密卡）
    // 3=无卡
    // 4=密码错误
    // 5=设备错误
    // 6=命令错误
    private String result;

    // CountUp
    private String countUp;

    // 内ID
    private String innerId;

    // 外ID
    private String outerId;

    @Override
    public void responseBody(MakeJKYCardResponse response, PrintRequest request) throws MeterException {
        response.setState(this.result);
        response.setCountUp(this.countUp);
        response.setInnerId(this.innerId);
        response.setOuterId(this.outerId);
        if (this.innerId != null) {
            response.setInnerCode(this.innerHex(PrintFactory.getInstance().obtainRSAEncryptDecrypt()));
        }
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = parseLength(1);
        if (CardState.result(this.result)) {
            this.countUp = parseBytes(4);
            this.innerId = parseText();
            this.outerId = parseText();
        }
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCountUp() {
        return countUp;
    }

    public void setCountUp(String countUp) {
        this.countUp = countUp;
    }

    public String getInnerId() {
        return innerId;
    }

    public void setInnerId(String innerId) {
        this.innerId = innerId;
    }

    public String getOuterId() {
        return outerId;
    }

    public void setOuterId(String outerId) {
        this.outerId = outerId;
    }

    /**
     * @description: Inner ID 解密
     **/
    public String innerHex(RSAEncryptDecrypt rsaEncryptDecrypt) {
        if (this.innerId != null && rsaEncryptDecrypt != null) {
            return ByteUtils.toHexString(rsaEncryptDecrypt.decrypt(this.innerId.trim().getBytes()));
        } else {
            return "";
        }
    }
}
