package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.em.CardState;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.ReadCardNumberResponse;

/**
 * @author lie_w
 * @title: Print0700Response
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-1310:47
 */
public class Print0700Response extends PrintCmdResponse<ReadCardNumberResponse, PrintRequest> {

    // 结果
    // 0=命令成功（吉卡云加密卡）
    // 3=无卡
    // 4=密码错误
    // 5=设备错误
    // 6=命令错误
    // 7=延迟状态
    // 8=超时错误
    private String result;

    // 卡号
    private String cardNum;

    @Override
    public void responseBody(ReadCardNumberResponse response, PrintRequest request) {
        response.setState(this.result);
        response.setCardNum(this.cardNum);
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = parseLength(1);
        if (CardState.result(this.result))
            this.cardNum = parseBytes(4);
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCardNum() {
        return cardNum;
    }

    public void setCardNum(String cardNum) {
        this.cardNum = cardNum;
    }
}
