package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.em.CardState;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.ReadPageResponse;

/**
 * @author lie_w
 * @title: Print0800Response
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-1312:05
 */
public class Print0800Response extends PrintCmdResponse<ReadPageResponse, PrintRequest> {

    // 结果
    // 0=命令成功（吉卡云加密卡）
    // 3=无卡
    // 4=密码错误
    // 5=设备错误
    // 6=命令错误
    private String result;

    private String readContent;

    @Override
    public void responseBody(ReadPageResponse response, PrintRequest request) {
        response.setState(this.result);
        response.setContent(this.readContent);
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = parseLength(1);
        if (CardState.result(this.result))
            this.readContent = parseLength(16);
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getReadContent() {
        return readContent;
    }

    public void setReadContent(String readContent) {
        this.readContent = readContent;
    }
}
