package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: Print0900Request
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-1312:27
 */
public class Print0900Request extends PrintCmdRequest<Print0900Response> {

    public Print0900Request() {
        super("0900");
    }

    private String writerContent;

    private Integer page;

    private String pwd = "FFFFFF";

    @Override
    public StringBuffer assembler() {
        return super.assembler()
                .append(this.writerContent)
                .append(ByteUtils.int2Hex(this.page))
                .append(StringUtils.isBlank(this.pwd) ? "FFFFFF" : this.pwd);
    }

    public String getWriterContent() {
        return writerContent;
    }

    public void setWriterContent(String writerContent) {
        this.writerContent = writerContent;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
}
