package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.WritePageResponse;

/**
 * @author lie_w
 * @title: Print0900Response
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-1312:28
 */
public class Print0900Response extends PrintCmdResponse<WritePageResponse, PrintRequest> {

    // 结果
    // 0=命令成功（吉卡云加密卡）
    // 3=无卡
    // 4=密码错误
    // 5=设备错误
    // 6=命令错误
    private String result;

    @Override
    public void responseBody(WritePageResponse response, PrintRequest request) {
        response.setState(this.result);
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = parseLength(1);
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }
}
