package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.em.CardState;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.produce.entity.ReadPageByPwdGroupResponse;

/**
 * @author lie_w
 * @title: Print0B00Response
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-1314:06
 */
public class Print0B00Response extends PrintCmdResponse<ReadPageByPwdGroupResponse, PrintRequest> {

    // 结果
    // 0=命令成功（吉卡云加密卡）
    // 3=无卡
    // 4=密码错误
    // 5=设备错误
    // 6=命令错误
    private String result;

    private String readContent;

    @Override
    public void responseBody(ReadPageByPwdGroupResponse response, PrintRequest request) {
        response.setState(this.result);
        response.setContent(this.readContent);
    }

    @Override
    public void analysis(PrintRequest request) {
        super.analysis(request);
        this.result = parseLength(1);
        if (CardState.result(this.result))
            this.readContent = parseLength(16);
    }
}
