package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.PrintStateCode;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.link.IPrintBack;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: PrintCmd
 * @projectName jhscale-agreement
 * @description: 命令 CMD
 * @date 2020-12-2315:02
 */
public class PrintCmdRequest<T extends PrintCmdResponse> extends PrintRequest<T> {

    // 命令标识
    private String cmd;

    public PrintCmdRequest() {
    }

    public PrintCmdRequest(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public PrintType printType() {
        return PrintType.CMD;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler().append(cmd);
    }

    /**
     * @description: 超时处理
     **/
    @Override
    public void timeOut() {
        try {
            this.getCommunication().sendCmd(this.printType().init(), this);
        } catch (MeterException e) {
            e.printStackTrace();
            IPrintBack printBack = this.getPrintBack();
            if (printBack != null)
                printBack.responseBack(PrintBackResponse.fail(this.getCommunication().getSerial(),
                        PrintStateCode.COMMUNICATION_TIME_OUT, "超时异常:" + e.getMessage()));
        }
        // 超时复位
        this.getCommunication().sendSuccess();
    }

    /**
     * @description: 获取文本
     **/
    public String assemblerText(String text) {
        String result = ByteUtils.toHexString(text.trim().getBytes(PrintFactory.getInstance().charset())).toUpperCase() + "00";
//        System.out.println(String.format("[%s] assemblerText [%s]", text, result));
        return result;
    }

    /**
     * @description: Int 2字节
     **/
    public String int2Byte(int val) {
        return ByteUtils.int2HexWithPush(val, 4);
    }
}
