package com.jhscale.meter.protocol.print.entity.cmd;

import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;

/**
 * @author lie_w
 * @title: PrintCmdResponse
 * @projectName jhscale-agreement
 * @description: 命令 CMD
 * @date 2020-12-2315:05
 */
public class PrintCmdResponse<T extends PrintBackResponse, U extends PrintRequest> extends PrintResponse<T, U> {

    private String cmd;

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public void analysis(U request) {
        this.cmd = parseLength(2);
    }

    /**
     * @description: 检查结果
     **/
    public boolean checkResult(String result) {
        return PrintConstant.SUCCESS.equals(result);
    }
}
