package com.jhscale.meter.protocol.print.entity.data;

import com.jhscale.meter.protocol.constant.TMS;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.para.CuttingPosition;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.utils.PrintUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

import static com.jhscale.meter.protocol.model.TradeContent.*;

/**
 * @author lie_w
 * @title: PrintDataRequest
 * @projectName jhscale-agreement
 * @description: 打印数据
 * @date 2020-12-2315:08
 */
public class PrintDataRequest<T extends PrintDataResponse> extends PrintRequest<PrintDataResponse> {

    // 打印数据
    private String data = "";

    // 打印数据
    private List<Para> paras;

    // 使用行模式打印
    private boolean linePrint = false;

    @Override
    public PrintType printType() {
        return PrintType.PRINT_DATA;
    }

    @Override
    public StringBuffer assembler() {
        if (this.linePrint && StringUtils.isNotBlank(this.data)) {
            this.data = this.Input_InitWidth() + this.data + this.Input_End();
        }
        return StringUtils.isNotBlank(this.data)
                ?
                super.assembler().append(data)
                :
                super.assembler().append(PrintUtils.compile(this.paras));
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<Para> getParas() {
        return paras;
    }

    public void setParas(List<Para> paras) {
        this.paras = paras;
    }

    /**
     * @description: 添加打印基础数据
     **/
    public PrintDataRequest addPara(Para para) {
        if (this.paras == null) this.paras = new ArrayList<>();
        this.paras.add(para);
        return this;
    }

    /**
     * @description: 清空基础打印缓冲区
     **/
    public PrintDataRequest clear() {
        if (this.paras != null) this.paras.clear();
        return this;
    }

    /**
     * @description: 添加打印
     **/
    public PrintDataRequest addPrintPoint() {
        return this.addPara(new PrintPara());
    }

    /**
     * @description: 添加打印到切纸
     **/
    public PrintDataRequest addPrintCutPoint() {
        return this.addPara(new CuttingPosition());
    }

    /**
     * @description: 添加打印并到切纸位置
     **/
    public PrintDataRequest addPrintPointAndCutPoint() {
        return this.addPrintPoint()
                .addPrintCutPoint();
    }

    /**
     * @description: 行模式打印
     **/

    private int initWidthDot = 48 * 8;

    /**
     * @description: 添加行打印数据
     **/
    private PrintDataRequest<T> Add_Line_Data(String... data) {
        if (this.data == null) this.data = "";
        if (data != null) {
            for (String datum : data) {
                this.data += datum;
            }
        }
        if (StringUtils.isNotBlank(this.data))
            this.linePrint = true;
        return this;
    }

    /**
     * @description: 打印开始
     **/
    private String Input_InitWidth() {
        int width = GlobalPara.getInstance().getTMS(TMS.Print_GenericLng_Wide);
        width = width != 0 ? width : 48;
        initWidthDot = width * 8;
        return "03" + printCalculate_getX2(GlobalPara.getInstance().getTMS(TMS.Print_GenericLng_Wide));
    }

    /**
     * @description: 打印结束
     **/
    private String Input_End() {
        return "07";
    }

    /**
     * @description: 使用位图打印
     **/
    public PrintDataRequest<T> Input_Bitmap(int bitmap) {
        String mapInfo = "0000020000000000" + printCalculate_getX4(initWidthDot) + "0001";
        return this.Add_Line_Data("16" + mapInfo + printCalculate_getX4(bitmap) + "04");
    }

    /**
     * @param left      左
     * @param mid       中
     * @param right     右
     * @param font      字体
     * @param multiLine 换行
     * @description: 文本打印
     **/
    public PrintDataRequest<T> Input_String(String left, String mid, String right, int font, boolean multiLine) {
        String head = multiLine ? "0020" : "0000";
        String end = printCalculate_getX2(font) + "00000000" + printCalculate_getX4(initWidthDot) + "0001";
        String mapInfo;
        if (StringUtils.isNotBlank(left)) {
            mapInfo = head + "01" + end;
            this.Add_Line_Data("12" + mapInfo + printCalculate_GetTextHex(left));
        }
        if (StringUtils.isNotBlank(mid)) {
            mapInfo = head + "02" + end;
            this.Add_Line_Data("12" + mapInfo + printCalculate_GetTextHex(mid));
        }
        if (StringUtils.isNotBlank(right)) {
            mapInfo = head + "03" + end;
            this.Add_Line_Data("12" + mapInfo + printCalculate_GetTextHex(right));
        }
        return this.Add_Line_Data("04");
    }

    /**
     * @description: 打印文本 左中右
     **/
    public PrintDataRequest<T> Input_String(String left, String mid, String right) {
        return this.Input_String(left, mid, right, GlobalPara.getInstance().getTMS(TMS.Print_GenericLng_ReportSize), false);
    }

    public PrintDataRequest<T> Input_String(String left, String mid, String right, int font) {
        return Input_String(left, mid, right, font, false);
    }

    public PrintDataRequest<T> Input_String(String left, String mid, String right, boolean multiLine) {
        return Input_String(left, mid, right, GlobalPara.getInstance().getTMS(TMS.Print_GenericLng_ReportSize), multiLine);
    }

    public PrintDataRequest<T> Input_String() {
        return Input_String(" ", null, null, GlobalPara.getInstance().getTMS(TMS.Print_GenericLng_ReportSize), false);
    }

    /**
     * @description: 打印字符换行模式
     **/
    public PrintDataRequest<T> Input_String(String content, boolean multiLine) {
        return Input_String(content, null, null, GlobalPara.getInstance().getTMS(TMS.Print_GenericLng_ReportSize), multiLine);
    }

    public PrintDataRequest<T> Input_String(String content, int font, boolean multiLine) {
        return Input_String(content, null, null, font, multiLine);
    }

    /**
     * @description: 打印条码
     **/
    public PrintDataRequest<T> Input_Barcode(String content, String barcodeType) {
        String mapInfo = "0000020000000000" + printCalculate_getX4(initWidthDot) + "0001";
        return this.Add_Line_Data("14" + mapInfo + barcodeType + printCalculate_GetBarcodeHex(content.getBytes()) + "04");
    }

    /**
     * @description: 打印二维码
     **/
    public PrintDataRequest<T> Input_QR(String content) {
        return Input_Barcode(content, "0B01030500000000");
    }
}
