package com.jhscale.meter.protocol.print.entity.data;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterPrintThermalException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.exp.MeterWarningException;
import com.jhscale.meter.protocol.print.PrintConstant;
import com.jhscale.meter.protocol.print.PrintGeneralFactory;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.cmd.Print0D00Request;
import com.jhscale.meter.protocol.print.produce.entity.PrintSendResponse;

import static com.jhscale.meter.protocol.print.PrintConstant.ONE;

/**
 * @author lie_w
 * @title: PrintDataResponse
 * @projectName jhscale-agreement
 * @description: 打印数据
 * @date 2020-12-2315:08
 */
public class PrintDataResponse extends PrintResponse<PrintSendResponse, PrintRequest> {

    // 状态1
    private String state1;

    // 状态2
    private String state2;

    /**
     * @param response
     * @param request
     * @description: 响应结果信息
     */
    @Override
    public void responseBody(PrintSendResponse response, PrintRequest request) {
        response.setBusy(PrintConstant.ZERO == this.state1.charAt(1));
        response.setCache(PrintConstant.ZERO == this.state1.charAt(2));
        response.setPaper(PrintConstant.ZERO == this.state2.charAt(1));
        response.setThermal(PrintConstant.ZERO == this.state2.charAt(2));
        response.setPaperSoon(PrintConstant.ZERO == this.state2.charAt(3));
        response.setPaperErr(PrintConstant.ZERO == this.state2.charAt(4));
        response.setPaperTake(PrintConstant.ZERO == this.state2.charAt(5));
        response.setUnclosed(PrintConstant.ZERO == this.state2.charAt(6));
    }

    @Override
    public void analysis(PrintRequest request) {
        this.state1 = toBitval();
        this.state2 = toBitval();
        PrintGeneralFactory.getInstance().putPrintState(this.getSerial(), this.state1, this.state2);
    }

    @Override
    @SuppressWarnings("all")
    public boolean analysisCheck(PrintRequest request) throws MeterException {
        if (ONE == this.state2.charAt(1)) {
            if (hasCache()) {
                throw new MeterException(MeterStateEnum.打印缺纸);
            } else {
                throw new MeterWarningException(MeterStateEnum.打印缺纸);
            }
        }


        if (ONE == this.state2.charAt(2)) {
            throw new MeterPrintThermalException(MeterStateEnum.打印过热);
            // if (hasCache()) {
            //     throw new MeterException(MeterStateEnum.打印过热);
            // } else {
            //     throw new MeterWarningException(MeterStateEnum.打印过热);
            // }
        }

        if (ONE == this.state2.charAt(4)) {
            if (hasCache()) {
                throw new MeterException(MeterStateEnum.标签纸异常);
            } else {
                throw new MeterWarningException(MeterStateEnum.标签纸异常);
            }
        }

        if (ONE == this.state2.charAt(5)) {
            request.getCommunication().sendDataWithoutAssemble(request);
            throw new MeterWarningException(MeterStateEnum.标签纸未拿走);   // TODO 需等待，而非异常
        }

        if (ONE == this.state2.charAt(6)) {
            if (hasCache()) {
                throw new MeterException(MeterStateEnum.打印机未关闭);
            } else {
                throw new MeterWarningException(MeterStateEnum.打印机未关闭);
            }
        }

        return true;
    }

    /**
     * @description: 检查缓冲
     **/
    private boolean hasCache() {
        boolean hasCache = ONE == this.state1.charAt(2);
        if (hasCache)
            PrintGeneralFactory.getInstance().execute(new Print0D00Request('D'));
        return hasCache;
    }

    public String getState1() {
        return state1;
    }

    public String getState2() {
        return state2;
    }
}
