package com.jhscale.meter.protocol.print.entity.data;

import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.para.RealBitmapPara;

/**
 * @author Loveven
 * @title: PrintRealBitmapRequest
 * @projectName jhscale-agreement
 * @description: 发送实时位图
 * @date 2021-01-2823:34
 */
@Deprecated
public class PrintRealBitmapRequest extends PrintRequest<PrintRealBitmapResponse> {

    private RealBitmapPara bitmapPara;

    // 发送完成之后打印
    private boolean print = false;

    // 走纸到撕纸位
    private boolean paper = false;

    @Override
    public PrintType printType() {
        return PrintType.PRINT_DATA;
    }

    @Override
    public String subContent() {
        return super.getSubContent();
    }

    public PrintRealBitmapRequest(RealBitmapPara bitmapPara) {
        this(bitmapPara, false, false);
    }

    public PrintRealBitmapRequest(RealBitmapPara bitmapPara, boolean print) {
        this(bitmapPara, print, false);
    }

    public PrintRealBitmapRequest(RealBitmapPara bitmapPara, boolean print, boolean paper) {
        this.bitmapPara = bitmapPara;
        this.print = print;
        this.paper = paper;
    }

    public RealBitmapPara getBitmapPara() {
        return bitmapPara;
    }

    public void setBitmapPara(RealBitmapPara bitmapPara) {
        this.bitmapPara = bitmapPara;
    }

    public boolean isPrint() {
        return print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public boolean isPaper() {
        return paper;
    }

    public void setPaper(boolean paper) {
        this.paper = paper;
    }

    /**
     * @description: 检查发送行数
     **/
    public boolean checkSend() {
        return bitmapPara.getBitMap().checkLine();
    }

    /**
     * @description: 填充发送内容
     **/
    public void getSubContent(int bufferLength) {
        String subContent = bitmapPara.getSubContent(bufferLength);
        System.out.println(String.format("实时位图片段内容：%s", subContent));
        this.setSubContent(subContent);
    }

    /**
     * @description: 获取处理进度
     **/
    public ScheduleState schedule() {
        return bitmapPara.schedule(this);
    }
}
