package com.jhscale.meter.protocol.print.entity.data;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.print.entity.PrintResponse;
import com.jhscale.meter.protocol.print.entity.para.CuttingPosition;
import com.jhscale.meter.protocol.print.entity.para.Para;
import com.jhscale.meter.protocol.print.entity.para.PrintPara;
import com.jhscale.meter.protocol.print.produce.entity.PrintBackResponse;
import com.jhscale.meter.protocol.print.produce.entity.PrintSendResponse;
import com.jhscale.meter.utils.PrintUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author Loveven
 * @title: PrintRealBitmapResponse
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-2823:51
 */
public class PrintRealBitmapResponse extends PrintResponse<PrintSendResponse, PrintRealBitmapRequest> {
    @Override
    public void callBack(String responseStr, PrintRealBitmapRequest request) {
        try {
            // 检查响应体
            super.checkResponse(responseStr);
            // 数据解析
            responseStr = this.parse(responseStr);
            if (StringUtils.isBlank(responseStr)) return;
            if (StringUtils.isNotBlank(super.getContent())) {
                // 具体内容解析
                this.analysis(request);
                // 具体内容有效性检查
                this.analysisCheck(request);
            }

            if (Objects.nonNull(request.getPrintBack())) {
                try {
                    request.getPrintBack().schedule(request.schedule());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
            }

            if (request.checkSend()) {
                if (request.isPrint() || request.isPaper()) {
                    // 以及发送完成
                    System.out.println("bitmap send success,printing or papering...");
                    List<Para> paras = new ArrayList<>();
                    if (request.isPrint()) paras.add(new PrintPara());
                    if (request.isPaper()) paras.add(new CuttingPosition());
                    request.setSubContent(PrintUtils.compile(paras));
                    request.getCommunication().addSendCmd(request.cmd(), request);
                    request.setPrint(false);
                    request.setPaper(false);
                    return;
                }
                PrintSendResponse response = reflexResponse(request);
                if (Objects.nonNull(request.getPrintBack()))
                    request.getPrintBack().responseBack(response);
            } else {
                if (Objects.nonNull(request.getPrintBack()) && (request.isSdk() || request.getCommunication().originalResponse()))
                    request.getPrintBack().responseBack(this);
                // 发送内容信息
                request.getSubContent(super.bufferLength());
                request.getCommunication().addSendCmd(request.cmd(), request);
            }
        } catch (MeterException e) {
            e.printStackTrace();
            if (Objects.nonNull(request.getPrintBack()))
                request.getPrintBack()
                        .responseBack(PrintBackResponse.fail(
                                request.getCommunication().getSerial(),
                                e.getMeterState().getCode(), e.getMeterState().getMsg()));
        }
    }

}
