package com.jhscale.meter.protocol.print.entity.data;

import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.PrintRequest;

/**
 * @author lie_w
 * @title: PrintDataRequest
 * @projectName jhscale-agreement
 * @description: 打印数据
 * @date 2020-12-2315:08
 */
public class PrintTradeRequest extends PrintRequest<PrintTradeResponse> {

    // 当前页数
    private Integer now;

    // 总页数
    private Integer total;

    // 打印内容
    private String hex;

    @Override
    public PrintType printType() {
        return PrintType.PRINT_DATA;
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler().append(this.hex);
    }

    public Integer getNow() {
        return now;
    }

    public void setNow(Integer now) {
        this.now = now;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public String getHex() {
        return hex;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }
}
