package com.jhscale.meter.protocol.print.entity.file;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.entity.PrintRequest;
import com.jhscale.meter.utils.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: PrintFileRequest
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2021-01-0522:37
 */
public class PrintFileRequest<T extends PrintFileResponse> extends PrintRequest<T> {

    // 升级文件
    private File file;

    // 流式升级文件名
    private String name;

    // 流式文件
    private InputStream inputStream;

    // 文件名解析参数
    private List<Integer> nameParams;

    // HEX 内容信息
    private String hexData;

    public PrintFileRequest() {
    }

    public PrintFileRequest(File file) {
        this.file = file;
    }

    public PrintFileRequest(String name, InputStream inputStream) {
        this.name = name;
        this.inputStream = inputStream;
    }

    public PrintFileRequest(String name, String hexData) {
        this.name = name;
        this.hexData = hexData;
    }

    public PrintFileRequest(String name) {
        this.name = name;
    }

    /**
     * @description: 检查升级文件
     **/
    public void checkUpgradeFile(String upgradeFileName) throws MeterException {
        if (StringUtils.isBlank(upgradeFileName))
            throw new MeterException(MeterStateEnum.文件名无效);
    }

    @Override
    public StringBuffer assembler() {
        return super.assembler()
                .append(StringUtils.isNotBlank(this.hexData) ?
                        this.hexData
                        :
                        (Objects.nonNull(this.file) ? FileUtils.fileToHex(this.file) : FileUtils.inputStreamToHex(this.inputStream)));
    }

    /**
     * @description: 获取文件名
     **/
    public String getUpgradeFileName() {
        return Objects.nonNull(this.file) ? file.getName() : this.name;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public List<Integer> getNameParams() {
        if (this.nameParams == null) this.nameParams = new ArrayList<>();
        return nameParams;
    }

    public void setNameParams(List<Integer> nameParams) {
        this.nameParams = nameParams;
    }

    public String getHexData() {
        return hexData;
    }

    public void setHexData(String hexData) {
        this.hexData = hexData;
    }
}
