package com.jhscale.meter.protocol.print.entity.file.bitmap;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.bitmap.FileBitMap;
import com.jhscale.meter.protocol.print.entity.file.PrintFileRequest;

import java.io.File;
import java.io.InputStream;

/**
 * @author lie_w
 * @title: PrintBitMapRequest
 * @projectName jhscale-agreement
 * @description: 位图数据
 * @date 2020-12-2316:57
 */
public class PrintBitMapRequest extends PrintFileRequest<PrintBitMapResponse> {

    // 升级位图信息
    private FileBitMap bitMap;

    public PrintBitMapRequest() {
    }

    public PrintBitMapRequest(File file) {
        super(file);
    }

    public PrintBitMapRequest(String name, InputStream inputStream) {
        super(name, inputStream);
    }

    public PrintBitMapRequest(String name, String hexData) {
        super(name, hexData);
    }

    public PrintBitMapRequest(String name, FileBitMap bitMap) {
        super(name, bitMap.getContent());
        this.bitMap = bitMap;
    }

    @Override
    public PrintType printType() {
        return PrintType.BIT_MAP;
    }

    @Override
    public void checkUpgradeFile(String upgradeFileName) throws MeterException {
        super.checkUpgradeFile(upgradeFileName);
        if (!upgradeFileName.endsWith(".bin")) {
            System.err.printf("位图文件名[%s]无效%n",upgradeFileName);
            throw new MeterException(MeterStateEnum.位图文件名无效);
        }
    }

    public FileBitMap getBitMap() {
        return bitMap;
    }
}
