package com.jhscale.meter.protocol.print.entity.file.font;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.file.PrintFileRequest;

import java.io.File;
import java.io.InputStream;

/**
 * @author lie_w
 * @title: PrintFontRequest
 * @projectName jhscale-agreement
 * @description: 字库数据
 * @date 2020-12-2316:53
 */
public class PrintFontRequest extends PrintFileRequest<PrintFontResponse> {

    public PrintFontRequest() {
    }

    public PrintFontRequest(File file) {
        super(file);
    }

    public PrintFontRequest(String name, InputStream inputStream) {
        super(name, inputStream);
    }

    public PrintFontRequest(String name, String hexData) {
        super(name, hexData);
    }

    public PrintFontRequest(String name) {
        super(name);
    }

    @Override
    public PrintType printType() {
        return PrintType.FONT;
    }

    @Override
    public void checkUpgradeFile(String upgradeFileName) throws MeterException {
        super.checkUpgradeFile(upgradeFileName);
        if (!upgradeFileName.endsWith(".bin")) {
            System.err.printf("字库文件名[%s]无效%n", upgradeFileName);
            throw new MeterException(MeterStateEnum.字库文件名无效);
        }

        String name = upgradeFileName.replace(".bin", "");
        String[] names = name.split("_");
        if (names.length == 0) {
            System.err.printf("字库文件名[%s]无效%n", upgradeFileName);
            throw new MeterException(MeterStateEnum.字库文件名无效);
        }

        try {
            // 设置升级的版本信息
            super.getNameParams().add(Integer.parseInt(names[1]));
        } catch (NumberFormatException e) {
            System.err.printf("字库文件名[%s]无效%n", upgradeFileName);
            throw new MeterException(MeterStateEnum.字库文件名无效);
        }
    }
}
