package com.jhscale.meter.protocol.print.entity.file.upgrade;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.em.PrintType;
import com.jhscale.meter.protocol.print.entity.file.PrintFileRequest;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: PrintUpgradeRequest
 * @projectName jhscale-agreement
 * @description: 升级数据
 * @date 2020-12-2316:54
 */
public class PrintUpgradeRequest extends PrintFileRequest<PrintUpgradeResponse> {

    public PrintUpgradeRequest() {
    }

    public PrintUpgradeRequest(File file) {
        super(file);
    }

    public PrintUpgradeRequest(String name, InputStream inputStream) {
        super(name, inputStream);
    }

    public PrintUpgradeRequest(String name, String hexData) {
        super(name, hexData);
    }

    public PrintUpgradeRequest(String name) {
        super(name);
    }

    @Override
    public PrintType printType() {
        return PrintType.UPGRADE;
    }

    @Override
    public void checkUpgradeFile(String upgradeFileName) throws MeterException {
        super.checkUpgradeFile(upgradeFileName);
        if (!upgradeFileName.startsWith("D") || !upgradeFileName.endsWith(".eup")) {
            System.err.printf("固件文件名 %s 无效", upgradeFileName);
            throw new MeterException(MeterStateEnum.固件文件名无效);
        }

        upgradeFileName = upgradeFileName.replace("D", "").replace(".eup", "");

        String[] names = upgradeFileName.split("_");
        if (names.length == 0) {
            System.err.printf("固件文件名 %s 无效", upgradeFileName);
            throw new MeterException(MeterStateEnum.固件文件名无效);
        }

        try {
            super.getNameParams().add(Integer.parseInt(names[0]));
            super.getNameParams().add(new BigDecimal(names[1].substring(0, 2)).multiply(new BigDecimal(512))
                    .add(new BigDecimal(names[1].substring(2, 4)).multiply(new BigDecimal(32)))
                    .add(new BigDecimal(names[1].substring(4, 6))).intValue());
        } catch (Exception e) {
            System.err.printf("固件文件名 %s 无效", upgradeFileName);
            throw new MeterException(MeterStateEnum.固件文件名无效);
        }
    }
}
