package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.protocol.print.em.ParaType;

import java.nio.charset.Charset;

/**
 * @author lie_w
 * @title: ChangeBitLines
 * @projectName jhscale-agreement
 * @description: 2.2.6 修改绘图标线
 * @date 2021-01-0812:47
 */
public class ChangeBitLines extends Para {

    // 改命令只会改大标线，而不会改小
    private Integer bitLine;

    public ChangeBitLines() {
        super(ParaType.Change_Bit_Line);
    }

    @Override
    public StringBuffer compile(Charset charset) {
        return super.compile(charset)
                .append(to2ByteHex(this.bitLine));
    }

    public Integer getBitLine() {
        return bitLine;
    }

    public void setBitLine(Integer bitLine) {
        this.bitLine = bitLine;
    }

    public ChangeBitLines setLine(Integer bitLine) {
        this.bitLine = bitLine;
        return this;
    }
}
