package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.print.em.Color;
import com.jhscale.meter.protocol.print.em.Dir;
import com.jhscale.meter.protocol.print.em.ParaType;

import java.nio.charset.Charset;
import java.util.Objects;

/**
 * @author lie_w
 * @title: FramePara
 * @projectName jhscale-agreement
 * @description: 3.3.7 绘制边框
 * @date 2020-12-2415:25
 */
public class FramePara extends Para {

    public FramePara() {
        super(ParaType.Frame);
    }

    // 方向 0°90°180°270°
    private Dir dir = Dir.ZERO;

    // 颜色
    private Color color = Color.BLACK;

    // 边框像素
    private Integer border;

    private Integer start_x;

    private Integer start_y;

    private Integer offset_x;

    private Integer offset_y;

    /**
     * @description: 设置方向
     **/
    public FramePara set_Dir(Dir dir) {
        this.dir = dir;
        return this;
    }

    /**
     * @description: 设置方向
     **/
    public FramePara set_Color(Color color) {
        this.color = color;
        return this;
    }

    /**
     * @description: 边框像素
     **/
    public FramePara set_Border(Integer border) throws MeterException {
        if (Objects.isNull(border) || border > 0xff)
            throw new MeterException(MeterStateEnum.边框像素不合法);
        this.border = border;
        return this;
    }

    public FramePara setStartX(Integer start_x) {
        this.start_x = start_x;
        return this;
    }

    public FramePara setStartY(Integer start_y) {
        this.start_y = start_y;
        return this;
    }

    public FramePara setOffsetX(Integer offset_x) {
        this.offset_x = offset_x;
        return this;
    }

    public FramePara setOffsetY(Integer offset_y) {
        this.offset_y = offset_y;
        return this;
    }

    @Override
    public StringBuffer compile(Charset charset) {
        return super.compile(charset)
                .append(this.dir.getHexVal())
                .append(this.color.getHexVal())
                .append(toHex(this.border))
                .append(to2ByteHex(this.start_x))
                .append(to2ByteHex(this.start_y))
                .append(to2ByteHex(this.offset_x))
                .append(to2ByteHex(this.offset_y));
    }

    public Dir getDir() {
        return dir;
    }

    public void setDir(Dir dir) {
        this.dir = dir;
    }

    public Color getColor() {
        return color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Integer getBorder() {
        return border;
    }

    public void setBorder(Integer border) {
        this.border = border;
    }

    public Integer getStart_x() {
        return start_x;
    }

    public void setStart_x(Integer start_x) {
        this.start_x = start_x;
    }

    public Integer getStart_y() {
        return start_y;
    }

    public void setStart_y(Integer start_y) {
        this.start_y = start_y;
    }
}
