package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.protocol.print.em.ParaType;

import java.nio.charset.Charset;

/**
 * @author lie_w
 * @title: Paper
 * @projectName jhscale-agreement
 * @description: 3.3.9 走纸n行，每8行=1mm
 * @date 2020-12-2415:30
 */
public class PaperPara extends Para {

    public PaperPara() {
        super(ParaType.Paper);
    }

    // 走纸行数
    private Integer line;

    /**
     * @description: 设置走纸
     **/
    public PaperPara set_Line(Integer line) {
        this.line = line;
        return this;
    }

    @Override
    public StringBuffer compile(Charset charset) {
        return super.compile(charset)
                .append(to2ByteHex(this.line));
    }

    public Integer getLine() {
        return line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }
}
