package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.protocol.print.em.ParaType;
import com.jhscale.meter.protocol.print.em.StrPara;
import com.jhscale.meter.utils.ByteUtils;

import java.nio.charset.Charset;
import java.util.List;

/**
 * @author lie_w
 * @title: Para
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2020-12-2412:40
 */
public class Para {

    // 绘制类型
    private ParaType type;

    public Para() {
    }

    public Para(ParaType type) {
        this.type = type;
    }

    public ParaType getType() {
        return type;
    }

    public void setType(ParaType type) {
        this.type = type;
    }

    /**
     * @description: 编译
     **/
    public StringBuffer compile(Charset charset) {
        return new StringBuffer(type.getHexVal());
    }

    /**
     * @description: 编译Para 标识
     **/
    protected String compileStrPara(List<StrPara> paras) {
        int val = 0;
        if (paras != null && !paras.isEmpty())
            for (StrPara para : paras) {
                val += para.getVal();
            }
        String paraHex = Integer.toHexString(val);
        return paraHex.length() % 2 != 0 ? "0" + paraHex : paraHex;
    }

    /**
     * @description: 转Hex
     **/
    protected String toHex(Integer val) {
        String hex = Integer.toHexString(val);
        return hex.length() % 2 != 0 ? "0" + hex : hex;
    }

    /**
     * @description: Int 转 2字节Hex
     **/
    protected static String to2ByteHex(Integer val) {
        String hex = Integer.toHexString(val);
        if (hex.length() < 4) {
            int appendLength = 4 - hex.length();
            for (int i = 0; i < appendLength; i++) {
                hex = "0" + hex;
            }
        }
        return ByteUtils.convert(hex);
    }
}
