package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.protocol.print.em.ParaType;

import java.nio.charset.Charset;

/**
 * @author lie_w
 * @title: PrintLinePara
 * @projectName jhscale-agreement
 * @description: 2.3.2 将绘图区根据指定行数打印
 * 注1	type=0时，当lines的行数大于绘图标线行数时，根据绘图标线打印，多余的行数忽略
 * 注2	type=1时，当lines的行数大于绘图标线行数时，根据绘图标线打印，多余的行数走空纸
 * @date 2021-01-0810:38
 */
public class PrintLinePara extends Para {

    private Integer ptype;

    private Integer lines;

    public PrintLinePara() {
        super(ParaType.Print_Line);
    }

    public PrintLinePara setType(Integer type) {
        this.ptype = type;
        return this;
    }

    public PrintLinePara setLine(Integer lines) {
        this.lines = lines;
        return this;
    }

    @Override
    public StringBuffer compile(Charset charset) {
        return super.compile(charset)
                .append(toHex(this.ptype))
                .append(toHex(this.lines));
    }

    public Integer getPtype() {
        return ptype;
    }

    public void setPtype(Integer ptype) {
        this.ptype = ptype;
    }

    public Integer getLines() {
        return lines;
    }

    public void setLines(Integer lines) {
        this.lines = lines;
    }
}
