package com.jhscale.meter.protocol.print.entity.para;

import com.jhscale.meter.protocol.print.PrintFactory;
import com.jhscale.meter.protocol.print.em.ParaType;
import com.jhscale.meter.protocol.print.entity.ScheduleState;
import com.jhscale.meter.protocol.print.entity.bitmap.RealBitMap;
import com.jhscale.meter.protocol.print.entity.data.PrintRealBitmapRequest;

import java.nio.charset.Charset;

/**
 * @author lie_w
 * @title: RealTimeBitmapPara
 * @projectName jhscale-agreement
 * @description: 3.3.5 绘制即时位图（暂缓调试, 需要切割）
 * @date 2020-12-2415:03
 */
@Deprecated
public class RealBitmapPara extends Para {

    public RealBitmapPara() {
        super(ParaType.Real_Time_Bitmap);
    }

    private Integer start_x;

    private Integer start_y;

    private Integer size_x;

    private Integer size_y;

    private String data;

    private RealBitMap bitMap;

    public RealBitmapPara setStartX(Integer start_x) {
        this.start_x = start_x;
        return this;
    }

    public RealBitmapPara setStartY(Integer start_y) {
        this.start_y = start_y;
        return this;
    }

    public RealBitmapPara setSizeX(Integer size_x) {
        this.size_x = size_x;
        return this;
    }

    public RealBitmapPara setSizeY(Integer size_y) {
        this.size_y = size_y;
        return this;
    }

    public RealBitmapPara setData(String data) {
        this.data = data;
        return this;
    }

    public RealBitmapPara setBitMap(RealBitMap bitMap) {
        this.bitMap = bitMap;
        return this;
    }

    @Override
    public StringBuffer compile(Charset charset) {
        return super.compile(charset)
                .append("00")
                .append("00")
                .append("00")
                .append("00")
                .append(to2ByteHex(this.start_x))
                .append(to2ByteHex(this.start_y))
                .append(to2ByteHex(this.size_x))
                .append(to2ByteHex(this.size_y))
                .append(this.data);
    }

    public Integer getStart_x() {
        return start_x;
    }

    public void setStart_x(Integer start_x) {
        this.start_x = start_x;
    }

    public Integer getStart_y() {
        return start_y;
    }

    public void setStart_y(Integer start_y) {
        this.start_y = start_y;
    }

    public Integer getSize_x() {
        return size_x;
    }

    public void setSize_x(Integer size_x) {
        this.size_x = size_x;
    }

    public Integer getSize_y() {
        return size_y;
    }

    public void setSize_y(Integer size_y) {
        this.size_y = size_y;
    }

    public String getData() {
        return data;
    }

    public RealBitMap getBitMap() {
        return bitMap;
    }

    /**
     * @description: 获取片段内容
     **/
    public String getSubContent(int bufferLength) {
        this.bitMap.getSubContent(this, bufferLength - 13);
        return this.compile(PrintFactory.getInstance().charset()).toString();
    }

    public ScheduleState schedule(PrintRealBitmapRequest request) {
        return bitMap.schedule(request);
    }
}
